#pragma once
#include "AI_Globals.h"

class AI_QValues
{
public:
	AI_QValues(AI_QValues_Type t): _type(t) {}
	virtual ~AI_QValues() {};

	virtual q_info get_qinfo(const AI_State& state) = 0;
	virtual STATE_VALUE update_qvalue(const AI_State& state, MOVE_ID move, STATE_VALUE nq) = 0;
	virtual STATE_VALUE update_reward(const AI_State& state, MOVE_ID move, STATE_VALUE rdelta) = 0;
	virtual void load(PLAYER_ID player_id) = 0;
	virtual void save(PLAYER_ID player_id) = 0;
	virtual size_t size() = 0;
	virtual void clear() = 0;

	AI_QValues_Type type() { return _type; }

protected:
	AI_QValues_Type _type;
};
