#pragma once
#include <hash_map>
#include "AI_Player.h"

class AI_Player_Impl :	public AI_Player
{
public:
	AI_Player_Impl(class LogicPlayer* _player);
	~AI_Player_Impl() {};

	MOVE_ID calculate_next_move();
	MOVE_ID current_move();
	void reset() { }
	void load(PLAYER_ID player_id);
	AI_PARAM get_param(const std::string& name) { return params[name]; }

private:
	typedef stdext::hash_map<std::string, AI_PARAM> ai_params_map;
	typedef ai_params_map::iterator p_iter;

	class LogicPlayer* player;
	ai_params_map params;

	// AI parameters
	float start_lr;
	float end_lr;
	float dL;
	float dr;
	float lambda;
	int H;
};
