#pragma once

#include <map>
#include <vector>
#include "util/llist.h"
#include "Globals.h"

enum AI_StateInspector_Type { si_standard=0 };
enum AI_QValues_Type { qv_standard=0 };
enum AI_Player_Type { p_standard=0 };
enum AI_SearchHeuristic_Type { sh_array=0 };

struct state_info
{
	state_info(): branch_var(0), value(0) {}
	state_info(STATE_VAR_ID _var, STATE_VALUE _value): branch_var(_var), value(_value) {}

	STATE_VAR_ID branch_var;
	STATE_VALUE value;
};

typedef std::vector<state_info> AI_State;

struct history_info
{
	history_info(MOVE_ID m, const AI_State& s, STATE_VALUE delta): move(m), state(s), obj_delta(delta) { } 

	MOVE_ID move;
	AI_State state;
	STATE_VALUE obj_delta;
};

struct qr_info
{
	qr_info(STATE_VALUE q, STATE_VALUE r): qvalue(q), reward(r) {}
	qr_info(): qvalue(0), reward(0) {}

	STATE_VALUE qvalue;
	STATE_VALUE reward;
};

typedef util::llist<history_info*> AI_History;
typedef AI_History::iterator hist_iter;
typedef std::map<MOVE_ID, qr_info> MQV_Map;
typedef MQV_Map::iterator MQV_iter;

struct q_info
{
	q_info(MQV_Map& m, float& r) : mqv_map(m), lr(r) {}
	MQV_Map& mqv_map;
	float& lr;
};

struct state_var_info
{
	STATE_VAR_ID id;
	std::string name;
	STATE_VALUE minimum_value;
	STATE_VALUE maximum_value;
	STATE_VALUE resolution;
};