#pragma once
#include "AI_SearchHeuristic.h"
#include "LogicPlayer.h"

class AI_ArrayHeuristic: public AI_SearchHeuristic
{
public:
	AI_ArrayHeuristic(LogicPlayer* _player) : AI_SearchHeuristic(sh_array), player(_player), index(0) {}
	~AI_ArrayHeuristic() {}
	
	void begin_traversal() { index = 0; }
	void next(STATE_VALUE sv) { index++; }
	STATE_VAR_ID branch_var() { return branch_vars[index]; }
	std::string branch_name() { return branch_names[index]; }
	bool at_end() { return branch_vars[index] == 0; }
	bool past_end() { return index == branch_vars.size(); }
	void initial_heuristic(const AI_State& state, q_info qinfo) {};
	void load(PLAYER_ID player_id);
	void save(PLAYER_ID player_id);

private:
	std::vector<STATE_VAR_ID> branch_vars;
	std::vector<std::string> branch_names;
	int index;

	LogicPlayer* player;
	AI_StateInspector* state_inspector;
};
