#include <fstream>
#include <sstream>

#include "AI_ArrayHeuristic.h"

using namespace std;

void AI_ArrayHeuristic::load(PLAYER_ID player_id)
{
	ostringstream filename;
	filename << "conf\\p" << player_id << ".heuristic";
	ifstream heuristic(filename.str().c_str());

	if (!heuristic)
	{
		heuristic.close();
		heuristic.clear();
		heuristic.open("conf\\default.heuristic");
	}

	state_inspector = player->state_inspector;
	string name;

	while (heuristic >> name)
	{
		branch_names.push_back(name);
		branch_vars.push_back(state_inspector->get_state_id(name));
	}

	heuristic.close();
}