/**
 @file Q3Map.cpp

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */

#include "dojo/Q3Map.h"

namespace dojo {

Q3Map::Q3Map(
    const std::string& name,
    const std::string& dir, 
    const std::string& bspFilename) : 
    Entity(name, "Root", Entity::FIXED, Entity::STILL) {

    mapmodel = Q3MapModel::create(dir, bspFilename);
    addGraphicsGeometry("Root", mapmodel);

    Array<Vector3>     vertexArray;
    Array<Vector3>     normalArray;
    Array<int>         indexArray;
    Array<Vector2>     texCoordArray;
    Array<int>         textureMapIndexArray;
    Array<Vector2>     lightCoordArray;
    Array<int>         lightMapIndexArray;
    Array<int>         texCoordIndexArray;
    Array<TextureRef>  textureMapArray;
    Array<TextureRef>  lightMapArray;

    mapmodel->posedModel->map->getTriangles(
        vertexArray, 
        normalArray,
        indexArray,
        texCoordArray, 
        textureMapIndexArray, 
        lightCoordArray, 
        lightMapIndexArray, 
        texCoordIndexArray, 
        textureMapArray, 
        lightMapArray);

    // Create the physics object
    MeshShape* mesh = new MeshShape(vertexArray, indexArray);
    addPhysicsGeometry("Root", mesh, 1);
}


const Array<BSPMAP::BSPEntity>& Q3Map::entityArray() const {
	return mapmodel->posedModel->map->entityArray;
}


const Array<BSPMAP::BSPModel>& Q3Map::modelArray() const {
	return mapmodel->posedModel->map->dynamicModels;
}


const Vector3& Q3Map::startingPosition() const {
	return mapmodel->posedModel->map->startingPosition;
}

} // dojo
