/**
 @file physicsunits.h

 Because it contains macros, this file is not included by default.

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_PHYSICS_UNITS_H
#define DOJO_PHYSICS_UNITS_H

// mks units
/** Distance */
#define METER           (1.0)
/** Mass (not weight!) */
#define KILOGRAM        (1.0)
/** Time */
#define SECOND          (1.0)
/** Angular measure */
#define RADIAN          (1.0)

/** Force (weight) */
#define NEWTON          (KILOGRAM * METER / (SECOND * SECOND))

// Already defined in G3D Game Units
//#define MINUTE          (60.0 * SECOND)
//#define HOUR            (60.0 * MINUTE)
//#define KILOMETER       (1000.0 * METER)

/** Units of torque */
#define JOULE           (NEWTON * METER)
#define WATT            (JOULE / SECOND)

/////////////////////////////////////////////////////
// English units
#define FOOT            (0.3048 * METER)
/** Pound is a unit of force (like NEWTONS), not a unit of mass.  
    Use SLUG if you want the English unit of mass, or for easier conversion,
    use POUND_WEIGHT to express the mass of an object weighing a given amount
    at the Earth's surface.*/
#define POUND           (4.44822162 * NEWTON)
#define POUND_WEIGHT    (0.4535924 * KILOGRAM)
#define SLUG            (14.5939029 * KILOGRAM)
#define MILE            (1609.344 * METER)
#define DEGREE          (RADIAN * 180.0 / G3D_PI)
#define HORSEPOWER      (745.69987 * WATT)

#endif
