/**

@mainpage

@section Debugging Debugging Controls

Dojo provides pop-up windows to aid in debugging your game.
The performance display on the upper right shows the actual frame rate and the 
relative amount of time each frame spent on each major task.  The pie chart underneath
the frame rate display graphs these relative times.  By clicking on the names of 
the six tasks (Sim, Gfx, Net, AI, etc.) you can bring up other debugging windows.

The Graphics popup displays rendering statistics.

The Simulation popup allows you to pause/unpause (F5), single step (F10), and
toggle display of physics collision proxies (F8).

Tab toggles the first-person-shooter debugging camera controls.

Esc quits the program.

@section QuickStart Quick Start

To make a game:
<ul>
<li> Subclass dojo::DApp
<li> Subclass dojo::DApplet 
  <ul> 
  <li>Put this in your DApplet::onGraphics method:
   <pre>
    app->renderDevice->setProjectionAndCameraMatrix(app->debugCamera);
    World::world()->onGraphics(app->renderDevice);
   </pre>
  <li> Put this in your DApplet::onSimulation method:
   <pre>
    if (sdt > 0) {
        World::world()->onSimulation(sdt);
    }
   </pre>
   </ul>
<li> Set dojo::app = your app
<li> Invoke dojo::DApplet::run on your applet
<li> Create a dojo::World
<li> Add some dojo::Entity objects into it.  Make your own subclass or use:
  <ul>
    <li> dojo::Crate
    <li> dojo::StickFigure
    <li> dojo::GroundPlane
    <li> dojo::Q2Character
    <li> dojo::Q2Map
  </ul>
</ul>

See dojo::Entity for information about making your own types of objects.  For every type of object, 
create a subclass of dojo::Entity and from the constructor invoke the dojo::Entity::addPart and other
methods to build the shape.  Instantiate the dojo::Entity once for each object in the world of that type.
Note that you can share dojo::GraphicsData between multiple dojo::Entity s.

@section Units Units
All unit arguments in Dojo are SI kg-m-s-radian units.  
#include "dojo/physicsunits.h" to define macros for many common physics
units.

<table>
<tr><td>Quantity</td><td>Unit</td><td>Macros</td></tr>
<tr><td>Mass</td><td>kilogram</td><td>KILOGRAM, SLUG, POUND_WEIGHT</td></tr>
<tr><td>Force</td><td>Newton</td><td>NEWTON, POUND</td></tr>
<tr><td>Time</td><td>second</td><td>SECOND, MINUTE, HOUR</td></tr>
<tr><td>Distance</td><td>meter</td><td>METER, FOOT, KILOMETER, MILE</td></tr>
<tr><td>Torque</td><td>Newton/s</td><td>JOULE</td></tr>
<tr><td>Angle</td><td>radian</td><td>RADIAN, DEGREE</td></tr>
</table>

@section Other Other Documentation
<a href="http://ode.org/ode-latest-userguide.html">ODE</a>

<a href="http://g3d-cpp.sourceforge.net/html/index.html">G3D</a>

@section Tools Recommended Tools
Rarewares' free <b>oggdrop</b> [http://audio.ciara.us/rarewares/oggdropXPdV1.8.6.zip]
for Windows allows easy conversion of WAV files to OGG files.

The free LMNO <b>Bitmap Font Builder</b> [http://www.lmnopc.com/bitmapfontbuilder/] converts
TTF files to the format imported by G3D::GFont for conversion to FNT files.

The shareware/$25 Chumbalumsoft <b>Milkshape</b> editor [http://www.swissquake.ch/chumbalum-soft/] can edit 3DS and MD2
files loaded by G3D::ArticulatedModel.  

The free <b>GIMP</b> paint program [http://www.gimp.org/] creates the
JPG, PNG, TGA, and PCX files loaded by G3D::Texture.

The free <b>Imagemagik</b> command line tools [http://www.imagemagick.org/script/index.php] can convert 
between many popular image formats.

The $37 screencapture program Fraps [http://www.fraps.com/] can record uncompressed videos of
your 3D program in action.  The free VirtualDub program [http://www.virtualdub.org/] can be used to edit
and compress these videos.

The free <b>iCompile</b> build system [http://ice.sf.net] compiles and links dojo games 
on Linux without any user configuration.

<b>CVS</b> is a free revision control system.  Commandline program: [http://www.nongnu.org/cvs/].
Windows explorer plugin: [http://www.tortoisecvs.org/]. Configuration notes: [http://graphics3d.com/guides/cvs/index.html].

<b>(Sub)Version</b> [http://subversion.tigris.org/] is another free revision control system that is
growing in popularity.  Windows explorer plugin: [http://tortoisesvn.tigris.org/].

The free <b>FMOD Sound Designer</b> tool [http://www.fmod.org/files/fmoddesigner10102win-installer.exe] 
produces audio files for use with FMOD, the audio library underlying dojo.

*/
