/**
 @file dojo/g3dHelper.h

 Brings in G3D and imports the G3D names that we use into the dojo namespace.
 We do not bring all of G3D into the dojo namespace because dojo defines its
 own, newer versions of some classes like GApp.

 See also http://g3d-cpp.sourceforge.net/html/index.html
 */
#ifndef DOJO_G3DHELPER_H
#define DOJO_G3DHELPER_H

#include <g3d/graphics3D.h>
#include <g3d/GLG3D.h>

using G3D::ReferenceCountedPointer;
using G3D::ReferenceCountedObject;
using G3D::Array;
using G3D::Set;
using G3D::Table;
using G3D::Queue;
using G3D::CoordinateFrame;
using G3D::Shape;
using G3D::ShapeRef;

using G3D::GFont;
using G3D::GFontRef;
using G3D::UserInput;
using G3D::RenderDevice;
using G3D::NetworkDevice;
using G3D::Texture;
using G3D::TextureRef;

using G3D::GWindow;

using G3D::Vector2;
using G3D::Vector3;
using G3D::Vector4;
using G3D::Color3;
using G3D::Color4;
using G3D::Matrix3;
using G3D::Matrix4;

using G3D::GLight;
using G3D::Lighting;
using G3D::LightingRef;
using G3D::Sky;
using G3D::SkyRef;
using G3D::TextureFormat;
using G3D::PosedModel;
using G3D::PosedModelRef;
using G3D::MeshAlg;
using G3D::VAR;
using G3D::VARArea;
using G3D::VARAreaRef;
using G3D::Shader;
using G3D::ShaderRef;
using G3D::VertexAndPixelShader;
using G3D::LightingParameters;
using G3D::Sphere;
using G3D::Box;
using G3D::AABox;
using G3D::Cylinder;
using G3D::Capsule;
using G3D::Triangle;
using G3D::Plane;
using G3D::Ray;
using G3D::toRadians;
using G3D::Log;
using G3D::TextInput;
using G3D::TextOutput;
using G3D::MD2ModelRef;
using G3D::Draw;
using G3D::iMin;
using G3D::iMax;
using G3D::inf;
using G3D::MD2Model;
using G3D::IFSModel;
using G3D::IFSModelRef;
using G3D::PhysicsFrame;
using G3D::GMaterial;
using G3D::BinaryInput;
using G3D::BinaryOutput;
using G3D::BoxShape;
using G3D::toLower;
using G3D::toUpper;
using G3D::debugPrintf;
using G3D::GImage;
using G3D::GLCaps;
using G3D::G3D_LITTLE_ENDIAN;
using G3D::format;
using G3D::fileExists;
using G3D::endsWith;
using G3D::TextureManager;
using G3D::filenamePath;
using G3D::Token;
using G3D::Rect2D;
using G3D::readFileAsString;
using G3D::iRound;
using G3D::Color3uint8;
using G3D::beginsWith;
using G3D::glGetBoolean;
using G3D::SimTime;
using G3D::RealTime;
using G3D::System;
using G3D::AM;
using G3D::PM;
using G3D::AMPM;
using G3D::PlaneShape;
using G3D::SphereShape;
using G3D::CapsuleShape;
using G3D::CylinderShape;
using G3D::RayShape;
using G3D::GAppSettings;
using G3D::GApp;
using G3D::GApplet;

using G3D::uint;
using G3D::iCeil;
using G3D::iFloor;

using G3D::Color4uint8;
using G3D::GCamera;
using G3D::MeshShape;

#endif
