/**
 @file dojo/dojo.h

 Brings in the Game Dojo library.
 Does <i>not</i> include the helper file "dojo/physicsunits.h", which introduces unit macros.
 */
#ifndef DOJO_H
#define DOJO_H

#include "g3dHelper.h"
#include "odeHelper.h"

#if G3D_VER < 60800
    #error Requires G3D 6.08
#endif

#include "AMUtil.h"
#include "DApp.h"
#include "ASFModel.h"
#include "SimpleModel.h"
#include "Q3MapModel.h"
#include "Entity.h"
#include "GraphicsData.h"
#include "World.h"
#include "ArticulatedModel/all.h"
#include "AudioDevice.h"

#include "StickFigure.h"
#include "Q2Character.h"
#include "Crate.h"
#include "GroundPlane.h"
#include "Q3Map.h"

#ifdef G3D_WIN32
#   ifdef _DEBUG
#       pragma comment(lib, "oded.lib")
#       pragma comment(lib, "OPCODE_D.lib")
#       pragma comment(lib, "dojod.lib")
#       pragma comment(lib, "fmodex_vc.lib")
#   else
#       pragma comment(lib, "ode.lib")
#       pragma comment(lib, "OPCODE.lib")
#       pragma comment(lib, "dojo.lib")
#       pragma comment(lib, "fmodex_vc.lib")
#   endif
#endif


#endif
