/**
 @file SimpleModel.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_SIMPLEMODEL_H
#define DOJO_SIMPLEMODEL_H

#include "g3dhelper.h"

namespace dojo {

typedef ReferenceCountedPointer<class SimpleModel> SimpleModelRef;

class SimpleModel : public ReferenceCountedObject {
private:

    IFSModelRef             ifs;

    bool                    smoothNormals;

    TextureRef              texture;

public:

    /** Filename must be a ply2 or ifs file */
    static SimpleModelRef create(const std::string& filename, TextureRef diffuseTexture);

    void pose(Array<PosedModelRef>& posedModels, const CoordinateFrame& cframe);
};

}

#endif
