/**
 @file Q3Map.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_Q3MAP_H
#define DOJO_Q3MAP_H

#include "dojo/Entity.h"
#include "dojo/Q3MapModel.h"

namespace dojo {

/**

 You can download existing Q3 (Quake 3 Team Arena) maps from http://www.polycount.com and other sites that 
 carry individual .bsp files as well as full Quake mods.  You can make your own maps using GtkRadiant from
 http://www.qeradiant.com/.
*/
class Q3Map : public Entity {
private:

    Q3Map(const std::string& name, const std::string& dir, const std::string& bspFilename);
	Q3MapModelRef mapmodel;

public:

    /**
     @param dir Directory containing "maps", "textures" and other subdirectories
     @param bspFilename Name of the .bsp file, which must be in dir/maps
     */
    static Q3Map* create(const std::string& name, const std::string& dir, const std::string& bspFilename) {
        return new Q3Map(name, dir, bspFilename);
    }

	/** e.g. Triggers, waypoints. Contain indices into the modelList.*/
	const Array<BSPMAP::BSPEntity>& entityArray() const;

	/** Dynamic models, e.g. elevators */
	const Array<BSPMAP::BSPModel>& modelArray() const;

	const Vector3& startingPosition() const;
};

}
#endif
