/**
 @file Q2Character.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_Q2CHARACTER_H
#define DOJO_Q2CHARACTER_H

#include "Entity.h"

namespace dojo {

typedef ReferenceCountedPointer<class Q2Character> Q2CharacterRef;

class Q2Character : public Entity {
protected:

    // Cleared by onSimulation, set by move
    bool m_crouching;
    bool m_movingForward;
    bool m_movingBackward;
    bool m_attacking;

    Q2Character(const std::string& name) : Entity(name, "Root"),
        m_crouching(false),
        m_movingForward(false),
        m_movingBackward(false), 
        m_attacking(false) {}

public:

    static EntityRef create(
        const std::string& name,
        MD2ModelRef& model0,
        TextureRef&  tex0,
        MD2ModelRef& model1,
        TextureRef&  tex1);

    /** mv is the userInput.getXY()*/
    void move(const Vector2& mv);

    /** Default implementation applies balance force. */
    virtual void onSimulation(SimTime d);
};

}
#endif
