/**
 @file GroundPlane.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */

#ifndef DOJO_GROUNDPLANE_H
#define DOJO_GROUNDPLANE_H

#include "Entity.h"

namespace dojo {

class GroundPlane : public Entity {
    GroundPlane() : Entity("Ground", "Root", Entity::FIXED, Entity::STILL, Entity::GROUND) {
        addGraphicsGeometry("Root", createPlaneModel("grid.png", 50, 1));
        addPhysicsGeometry("Root", new PlaneShape(Plane(Vector3::unitY(), Vector3::zero())), 1);
    }
public:

    static EntityRef create() {
        return EntityRef(new GroundPlane());
    }
};

}

#endif
