/**
 @file G3UI.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */

#ifndef DOJO_G3UI_H
#define DOJO_G3UI_H

#include "dojo/g3dHelper.h"

namespace dojo {

/**
 Immediate mode rendering for GUI elements.
 Used to build retained mode GUIs.
*/
class G3UI {
public:

    // Window constants
    static const Color4 activeBackColor;
    static const Color4 inactiveBackColor;

    static const Color4 activeTitleBarColor;
    static const Color4 inactiveTitleBarColor;

    static const Color4 inactiveBorderColor;
    static const Color4 activeBorderColor;

    static const Color4 buttonColor;
    static const Color4 buttonHilightColor;
    static const Color4 buttonDarkColor;
    static const Color4 buttonShadowColor;

    static const Color4 buttonCaptionColor;

    static const Color4 activeTitleBarTitleColor;
    static const Color4 inactiveTitleBarTitleColor;

    static const float  titleBarHeight;

    /**
    If icon is NULL it is not drawn
    */
    static void drawButton(RenderDevice* rd, const Rect2D& rect, TextureRef icon, bool buttonPushed);
    /**
    A window contains a title bar and a client area.
    Drawing the window does not draw the close button.
    */
    static void drawWindow(RenderDevice* rd, GFontRef titleFont, const std::string& title, const Rect2D& rect, bool active);

    /** Add a close button to the window.  Note that the argument is the window rect, not the button rect. */
    static void drawCloseButton(RenderDevice* rd, const Rect2D& windowRect, bool pushed);
    
    static Rect2D windowClientArea(const Rect2D& windowRect);

    /** Returns true if the position is on the title bar of the window (might be the close button). */
    static bool inWindowTitleBar(const Vector2& pos, const Rect2D& windowRect);

    /** Returns true if the position is on the close button of this window. */
    static bool inCloseButton(const Vector2& pos, const Rect2D& windowRect);

    /**
     @param position range 0 - 1
     */
    static void drawSlider(RenderDevice* rd, const Rect2D& rect, float f, bool thumbPushed);
};

}

#endif
