/**
 @file DApp.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_DAPP_H
#define DOJO_DAPP_H

#include "g3dHelper.h"
#include "AudioDevice.h"
#include "World.h"
#include "HUDUI.h"

namespace dojo {

/**
 Your game should have a class Game : public DApp that subclasses this.
 */
class DApp : public GApp {
protected:
    friend class HUDUI;

    virtual void main() {}

    virtual void loadScene() {}

    /** Render FPS */
    float               m_desiredFrameRate;

    float               m_simTimeRate;

    bool                m_paused;

    bool                m_singleStep;

    class DApplet*      currentApplet;

public:

    HUDUI               hudUI;

    AudioDevice*        audioDevice;

    DApp(const GAppSettings& settings, GWindow* window);

    void debugSetPaused(bool p);

    void debugSetSingleStep(bool s);

    /** Pause simulation for debugging. Called by HUDUI. */
    bool debugPaused() const {
        return m_paused;
    }

    bool debugSingleStep() const {
        return m_singleStep;
    }


    void setApplet(class DApplet* a);

    virtual ~DApp();
};



/**
 Each "mode" for the game should be a different DApp subclass.  E.g.
 TitleScreen, Game, ConfigScreen, Credits.
 */
class DApplet : public GApplet {
private:

    DApp*               app;

protected:

    void drawDebugHUD();

public:

    DApplet(DApp* app) : GApplet(app), app(app) {}

    /** Subclasses must call */
    virtual void onInit();

    virtual void onGraphics(RenderDevice* rd);

    virtual void onUserInput(UserInput* ui);

    virtual void onSimulation(RealTime rdt, SimTime sdt, SimTime idt);

    /** Subclasses must call. */
    virtual void onCleanup();
};

extern DApp* app;

}

#endif
