/**
 @file Crate.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_CRATE_H
#define DOJO_CRATE_H

#include "Entity.h"

namespace dojo {

class Crate : public Entity {
private:

    Crate(const std::string& name) : Entity(name, "Root") {}

public:

    static EntityRef wood(const std::string& name) {
        static TextureRef tex = Texture::fromFile("wood-crate.jpg");
        static ArticulatedModelRef body = ArticulatedModel::fromFile("uniform-crate.ifs");
        static bool initialized = false;

        if (! initialized) {
            SuperShader::Material material;
            material.diffuse.constant = Color3::white();
            material.diffuse.map   = tex;
            
            material.emit      = Color3::black();
            material.transmit  = Color3::black();
            material.reflect   = Color3::black();
            material.specular  = Color3::white() * .1f;
            material.specularExponent = Color3::white() * 80;

            body->partArray.last().triListArray[0].material = material;
            body->updateAll();
            initialized = true;
        }

        Crate* c = new Crate(name);
        c->addGraphicsGeometry("Root", body);
        c->addPhysicsGeometry(
            "Root",
            new BoxShape(Box(Vector3(-0.5, -0.5, -0.5), Vector3(0.5, 0.5, 0.5))),
            30);
        return EntityRef(c);
    }
};

}
#endif
