/**
 @file AudioDevice.h

 Dojo Game Engine

 Copyright 2005, Morgan McGuire
 All rights reserved.
 */
#ifndef DOJO_AUDIODEVICE_H
#define DOJO_AUDIODEVICE_H

#include "fmod/fmod.hpp"

namespace dojo {

class AudioDevice {
private:

    FMOD::System*        system;

public:
    AudioDevice() : system(NULL) {
    }

    ~AudioDevice() {
        system->close();
        system->release();
        system = NULL;
    }

    void init() {
        FMOD::System_Create(&system);
        system->init(100, FMOD_INIT_NORMAL, 0);
    }

};



class Sound  : public ReferenceCountedObject {
public:

    /** Distance in meters at which the sound will begin to attenuate in 3D */ 
    float beginFade3D() const;

    /** An instance of a sound that is playing; to be used as a handle to change
        the 3D position.  Primarily used by dojo::Entity and dojo::World.*/
    class Instance : public ReferenceCountedObject {
    public:
        enum Mode {PLAYING, PAUSED, STOPPED};

        /** Make this instance cease playing (if it has not already) */
        void stop();
        
        /** Temporarily pause playback. */
        void pause();

        /** Restart a paused instance. It is an error to call this 
            when not paused or after stopped. */
        void play();

        Mode mode();

        void setVolume(float v);
    };
    
    typedef ReferenceCountedPointer<Instance> InstanceRef;

    class Instance3D : public Instance {
    public:
        void setPosition(const Vector3& pos, const Vector3& vel);
    };

    typedef ReferenceCountedPointer<Instance3D> Instance3DRef;

//    Instance2DRef play2D();

    Instance3DRef play3D(const Vector3& pos, const Vector3& vel);
};

}

#endif
