/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class TrackballCamera {
    protected Canvas3D canvas_;
    protected BranchGroup camRoot_;
    protected TransformGroup xform_;
    protected ViewPlatform vp_;
    protected View view_;
    protected Vector3d rot_;
    protected Point3d offset_;
    protected double zoom_;
    protected int lastx_;
    protected int lasty_;
    protected Vector3d xi_;
    protected Vector3d yi_;
    protected Vector3d zi_;
    protected Vector3d look_;
    protected int mode_;
    protected Transform3D old_xf;
    private static final double ROT_PCT = 0.1;
    private static final double ZOOM_FACTOR = 0.02;
    public static final int MODE_NONE = 0;
    public static final int MODE_ROTATE = 1;
    public static final int MODE_PAN = 2;
    public static final int MODE_ZOOM = 3;
    private ObjectList _cam_listeners;
    private ObjectIterator _cam_iter;

    public TrackballCamera(Canvas3D canvas3D) {
        this.canvas_ = canvas3D;
        this.camRoot_ = new BranchGroup();
        this.offset_ = new Point3d(0.0, 0.0, 0.0);
        this.rot_ = new Vector3d(1.0, 1.0, 1.0);
        this.rot_.normalize();
        this.zoom_ = 1.0;
        this.xform_ = new TransformGroup();
        this.xform_.setCapability(17);
        this.xform_.setCapability(18);
        this.camRoot_.addChild((Node)this.xform_);
        this.vp_ = new ViewPlatform();
        this.vp_.setViewAttachPolicy(3);
        this.xform_.addChild((Node)this.vp_);
        this.view_ = new View();
        this.view_.addCanvas3D(this.canvas_);
        PhysicalBody physicalBody = new PhysicalBody(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0));
        physicalBody.setLeftEyePosition(new Point3d(0.0, 0.0, 0.0));
        physicalBody.setNominalEyeHeightFromGround(0.0);
        this.view_.setProjectionPolicy(0);
        this.view_.setPhysicalBody(physicalBody);
        this.view_.setPhysicalEnvironment(new PhysicalEnvironment());
        this.view_.attachViewPlatform(this.vp_);
        this.xi_ = new Vector3d();
        this.yi_ = new Vector3d();
        this.zi_ = new Vector3d();
        this._cam_listeners = new ObjectList();
        this._cam_iter = new ObjectIterator(this._cam_listeners);
        this.old_xf = new Transform3D();
        this.updateCamera();
    }

    public void addCamListener(CamListener camListener) {
        this._cam_listeners.add(camListener);
    }

    public Vector3d getLook() {
        return this.look_;
    }

    public BranchGroup getRoot() {
        return this.camRoot_;
    }

    public TransformGroup getTransform() {
        return this.xform_;
    }

    public View getView() {
        return this.view_;
    }

    public void getXProj(Vector3d vector3d) {
        vector3d.set((Tuple3d)this.xi_);
    }

    public void getYProj(Vector3d vector3d) {
        vector3d.set((Tuple3d)this.yi_);
    }

    public void getZProj(Vector3d vector3d) {
        vector3d.set((Tuple3d)this.zi_);
    }

    public Matrix4d hackLookAt(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d) {
        this.look_ = new Vector3d();
        this.look_.set((Tuple3d)point3d2);
        this.look_.sub((Tuple3d)point3d);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.cross(this.look_, vector3d);
        vector3d2.normalize();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.set((Tuple3d)this.look_);
        vector3d3.scale(-1.0);
        vector3d3.normalize();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d3, vector3d2);
        vector3d2.scale(d);
        vector3d4.scale(d);
        vector3d3.scale(d);
        return new Matrix4d(vector3d2.x, vector3d4.x, vector3d3.x, point3d.x, vector3d2.y, vector3d4.y, vector3d3.y, point3d.y, vector3d2.z, vector3d4.z, vector3d3.z, point3d.z, 0.0, 0.0, 0.0, 1.0);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        if (Math.abs(mouseEvent.getX() - this.lastx_) + Math.abs(mouseEvent.getY() - this.lasty_) < 4) {
            return;
        }
        Dimension dimension = this.canvas_.getSize();
        boolean bl2 = mouseEvent.getX() < (int)((double)dimension.width * 0.1) || mouseEvent.getX() > (int)((double)dimension.width - (double)dimension.width * 0.1);
        boolean bl3 = bl = mouseEvent.getY() < (int)((double)dimension.height * 0.1) || mouseEvent.getY() > (int)((double)dimension.height - (double)dimension.height * 0.1);
        if (this.mode_ == 0) {
            this.mode_ = mouseEvent.isShiftDown() ? 1 : (bl2 || bl ? 1 : (mouseEvent.isControlDown() ? 3 : (Math.abs(mouseEvent.getX() - this.lastx_) < Math.abs(mouseEvent.getY() - this.lasty_) ? 3 : 2)));
        }
        switch (this.mode_) {
            case 1: {
                this.spinCamera(mouseEvent);
                break;
            }
            case 2: {
                this.panCamera(mouseEvent);
                break;
            }
            case 3: {
                this.zoomCamera(mouseEvent);
                break;
            }
        }
        this.lastx_ = mouseEvent.getX();
        this.lasty_ = mouseEvent.getY();
        this._cam_iter.init();
        while (!this._cam_iter.isDone()) {
            ((CamListener)this._cam_iter.curr()).camMoved(this.mode_);
            this._cam_iter.incr();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mode_ = 0;
        this.lastx_ = mouseEvent.getX();
        this.lasty_ = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void panCamera(MouseEvent mouseEvent) {
        Transform3D transform3D = new Transform3D();
        this.canvas_.getImagePlateToVworld(transform3D);
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        this.canvas_.getPixelLocationInImagePlate(this.lastx_, this.lasty_, point3d);
        this.canvas_.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d2);
        transform3D.transform(point3d);
        transform3D.transform(point3d2);
        Vector3d vector3d = new Vector3d();
        vector3d.set((Tuple3d)point3d);
        vector3d.sub((Tuple3d)point3d2);
        this.offset_.add((Tuple3d)vector3d);
    }

    protected void spinCamera(MouseEvent mouseEvent) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        this.canvas_.getPixelLocationInImagePlate(this.lastx_, this.lasty_, point3d);
        this.canvas_.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d2);
        vector3d.set((Tuple3d)point3d2);
        vector3d.sub((Tuple3d)point3d);
        Transform3D transform3D = new Transform3D();
        this.canvas_.getImagePlateToVworld(transform3D);
        transform3D.transform(vector3d);
        this.rot_.sub((Tuple3d)vector3d);
        this.rot_.normalize();
    }

    public void updateCamera() {
        Transform3D transform3D = new Transform3D();
        this.xform_.getTransform(transform3D);
        if (!transform3D.equals(this.old_xf)) {
            System.out.println("Krazy Kamera stuff");
            System.out.println(this.old_xf);
            System.out.println(transform3D);
        }
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d(this.rot_);
        vector3d.scale(16.0);
        point3d.set((Tuple3d)vector3d);
        point3d.add((Tuple3d)this.offset_);
        Transform3D transform3D2 = new Transform3D(this.hackLookAt(point3d, this.offset_, new Vector3d(0.0, 1.0, 0.0), this.zoom_));
        this.xform_.setTransform(transform3D2);
        this.updateProjections();
        this.xform_.getTransform(this.old_xf);
    }

    public void updateProjections() {
        Transform3D transform3D = new Transform3D();
        this.canvas_.getVworldToImagePlate(transform3D);
        transform3D.transform(new Vector3d(1.0, 0.0, 0.0), this.xi_);
        transform3D.transform(new Vector3d(0.0, 1.0, 0.0), this.yi_);
        transform3D.transform(new Vector3d(0.0, 0.0, 1.0), this.zi_);
    }

    protected void zoomCamera(MouseEvent mouseEvent) {
        int n = this.lasty_ - mouseEvent.getY();
        if (this.zoom_ > 0.6 && this.zoom_ < 20.0 || n > 0 && this.zoom_ < 20.0 || n < 0 && this.zoom_ > 0.6) {
            this.zoom_ += (double)n * 0.02;
        }
    }
}

