/*
 * Decompiled with CFR 0.152.
 */
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

class SilhEdge {
    protected Point3d[] _world_pts;
    protected LineSeg2d[] _screen_edges;
    protected Shape3DList _edge_fragments;
    protected int[] _ptvis;
    protected boolean _shapes_uptodate;
    protected Color3f _color;
    protected Color3f _color_occluded;
    protected boolean _show_occl;
    protected boolean _shade;
    protected int _num_shade_lines;
    protected Vector3d[] _offsets;

    SilhEdge(Silhouette silhouette, Transform3D transform3D, Point3dList point3dList) {
        int n = silhouette.list().num();
        this._world_pts = new Point3d[n];
        this._ptvis = new int[n];
        int n2 = 0;
        while (n2 < this._ptvis.length) {
            this._ptvis[n2] = 2;
            ++n2;
        }
        this._shade = true;
        if (this._shade) {
            this._offsets = new Vector3d[n];
            int n3 = 0;
            while (n3 < this._offsets.length) {
                this._offsets[n3] = new Vector3d();
                ++n3;
            }
        }
        this._num_shade_lines = 3;
        this._color = new Color3f(0.0f, 0.0f, 0.6f);
        this._color_occluded = new Color3f(1.0f, 1.0f, 1.0f);
        this._show_occl = false;
        this._shapes_uptodate = false;
        this._screen_edges = new LineSeg2d[n - 1];
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3dIterator point3dIterator = new Point3dIterator(silhouette.list());
        point3dIterator.init();
        point3dList.add(point3dIterator.curr());
        this._world_pts[0] = point3dIterator.curr();
        point3d.set((Tuple3d)point3dIterator.curr());
        transform3D.transform(point3d);
        point3dIterator.incr();
        int n4 = 1;
        while (!point3dIterator.isDone()) {
            if (n4 % 5 == 0) {
                point3dList.add(point3dIterator.curr());
            }
            this._world_pts[n4] = point3dIterator.curr();
            point3d = point3d2;
            point3dIterator.incr();
            ++n4;
        }
        this._edge_fragments = new Shape3DList();
    }

    public void draw(GraphicsContext3D graphicsContext3D) {
        if (!this._shapes_uptodate) {
            this.updateShapes();
        }
        Shape3DIterator shape3DIterator = new Shape3DIterator(this._edge_fragments);
        shape3DIterator.init();
        while (!shape3DIterator.isDone()) {
            graphicsContext3D.draw(shape3DIterator.curr());
            shape3DIterator.incr();
        }
    }

    public LineSeg2d getScreenEdge(int n) {
        return this._screen_edges[n];
    }

    public LineSeg2d[] getScreenEdges() {
        return this._screen_edges;
    }

    public int len() {
        return this._screen_edges.length;
    }

    protected void makeLines(int n, int n2, boolean bl) {
        if (n == n2) {
            return;
        }
        if (!bl) {
            this._edge_fragments.add(ShapeMaker.makeLineStrip(this._world_pts, n, n2, this._color));
        } else {
            this._edge_fragments.add(ShapeMaker.makeLineStrip(this._world_pts, n, n2, this._color_occluded));
        }
        if (!this._shade || bl) {
            return;
        }
        Point3d[] point3dArray = new Point3d[n2 - n + 1];
        int n3 = 0;
        while (n3 < point3dArray.length) {
            point3dArray[n3] = new Point3d(this._world_pts[n3 + n]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this._num_shade_lines) {
            Color3f color3f;
            double d = 0.35;
            int n5 = 0;
            while (n5 < point3dArray.length) {
                point3dArray[n5].scaleAdd(d, (Tuple3d)this._offsets[n5 + n], (Tuple3d)point3dArray[n5]);
                color3f = new Vector3d(Math.random(), Math.random(), Math.random());
                color3f.scale(0.01);
                point3dArray[n5].add((Tuple3d)color3f);
                ++n5;
            }
            color3f = new Color3f(this._color);
            Color3f color3f2 = new Color3f(0.9f, 0.9f, 0.9f);
            color3f.scale((float)(this._num_shade_lines - n4));
            color3f.scaleAdd((float)n4, (Tuple3f)color3f2, (Tuple3f)color3f);
            color3f.scale(1.0f / (float)this._num_shade_lines);
            this._edge_fragments.add(ShapeMaker.makeBrokenLineStrip(point3dArray, 0, point3dArray.length - 1, color3f, color3f2, (double)n4 / (double)this._num_shade_lines));
            ++n4;
        }
    }

    public Vector3d[] offsets() {
        return this._offsets;
    }

    public void setOffset(int n, Vector3d vector3d) {
        this._offsets[n].set((Tuple3d)vector3d);
    }

    public void setVis(int n, boolean bl) {
        this._ptvis[n] = bl ? 0 : 1;
    }

    public boolean shade() {
        return this._shade;
    }

    protected void updateShapes() {
        this._edge_fragments.clear();
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this._ptvis.length) {
            if (this._ptvis[n6] != 2) {
                n2 = this._ptvis[n6];
                break;
            }
            ++n6;
        }
        if (n2 == -1) {
            this.makeLines(0, this._world_pts.length - 1, false);
            return;
        }
        ++n6;
        while (n6 < this._ptvis.length) {
            n = this._ptvis[n6];
            if (n != 2) {
                if (n != n2) {
                    n4 = (n5 + n6) / 2;
                    if (n2 == 0) {
                        this.makeLines(n3, n4, false);
                    } else if (this._show_occl) {
                        this.makeLines(n3, n4, true);
                    }
                    n3 = n4;
                    n2 = n;
                }
                n5 = n6;
            }
            ++n6;
        }
        if (n3 != this._ptvis.length - 1) {
            n4 = this._ptvis.length - 1;
            if (n2 == 0) {
                this.makeLines(n3, n4, false);
            } else if (this._show_occl) {
                this.makeLines(n3, n4, true);
            }
        }
        this._shapes_uptodate = true;
    }

    public Point3d[] worldPts() {
        return this._world_pts;
    }
}

