/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class RayShooter {
    private BranchGroup _bg;
    private TrackballCamera _cam;
    private ImplCanvas3D _canvas;
    private ModelTracer _mt;
    private ModelTracer2 _mt2;
    private Point3dCache _pt_cache;

    public RayShooter(BranchGroup branchGroup, TrackballCamera trackballCamera, ImplCanvas3D implCanvas3D, Function3D function3D) {
        this._bg = branchGroup;
        this._cam = trackballCamera;
        this._canvas = implCanvas3D;
        this._mt = new ModelTracer(function3D);
        this._mt2 = new ModelTracer2(function3D);
        this._pt_cache = new Point3dCache(this._mt.getTracingStepsize());
    }

    public void clearCache() {
        this._pt_cache.clear();
    }

    public Point3d imgToWorld(int n, int n2) {
        Point3d point3d = new Point3d();
        this._canvas.getPixelLocationInImagePlate(n, n2, point3d);
        Transform3D transform3D = new Transform3D();
        this._canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        return point3d;
    }

    public void markEndpt(Point3dList point3dList, Point3d point3d, BranchGroup branchGroup, double d) {
        Point3d point3d2 = point3dList.getLast();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d = this._mt.getFunc().gradient(point3d2);
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        vector3d2.cross(vector3d, vector3d3);
        vector3d2.normalize();
        vector3d2.scale(d);
        point3d3.add((Tuple3d)point3d2, (Tuple3d)vector3d2);
        point3d4.sub((Tuple3d)point3d2, (Tuple3d)vector3d2);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        Vector3d vector3d5 = new Vector3d();
        Matrix3d matrix3d = this._mt.getFunc().hessian(point3d2);
        matrix3d.transform((Tuple3d)vector3d4, (Tuple3d)vector3d5);
        float f = (float)vector3d4.dot(vector3d5);
        f /= 160.0f;
        f = (float)((double)f - 0.5);
        if (f > 0.0f) {
            branchGroup.addChild((Node)ShapeMaker.makeLineSeg(point3d3, point3d4, new Color3f(0.0f, f, 0.0f)));
        } else {
            branchGroup.addChild((Node)ShapeMaker.makeLineSeg(point3d3, point3d4, new Color3f(Math.abs(f), 0.0f, 0.0f)));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point3d point3d = new Point3d();
        this._canvas.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d);
        System.out.println("Canvas Pos:" + point3d.x + "," + point3d.y);
        Point3d point3d2 = this.imgToWorld(mouseEvent.getX(), mouseEvent.getY());
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        Vector3d vector3d = this._cam.getLook();
        Transform3D transform3D = new Transform3D();
        this._canvas.getImagePlateToVworld(transform3D);
        Point3d point3d3 = new Point3d();
        this._canvas.getPixelLocationInImagePlate(mouseEvent.getX(), mouseEvent.getY(), point3d3);
        transform3D.transform(point3d3);
        Point3d point3d4 = new Point3d();
        boolean bl = this._mt.intersect(point3d3, vector3d, 100.0, point3d4);
        if (bl) {
            Point3dList point3dList = this._mt.tracePath(point3d4, vector3d);
            if (point3dList != null && point3dList.num() > 1) {
                branchGroup.addChild((Node)ShapeMaker.makeLineStrip(point3dList, new Color3f(0.0f, 0.2f, 1.0f)));
            }
            if ((point3dList = this._mt.newTracePath(point3d4, vector3d)) != null && point3dList.num() > 1) {
                Point3dIterator point3dIterator;
                branchGroup.addChild((Node)ShapeMaker.makeLineStrip(point3dList, new Color3f(0.7f, 0.7f, 0.0f)));
                Point3d point3d5 = point3dList.getLast();
                Silhouette silhouette = this._mt.traceSilh(point3d5, vector3d);
                Silhouette silhouette2 = this._mt2.traceSilh(point3d5, vector3d);
                Point3dList point3dList2 = silhouette.list();
                if (point3dList2 != null && point3dList2.num() > 1) {
                    point3dIterator = new Point3dIterator(point3dList2);
                    branchGroup.addChild((Node)ShapeMaker.makeLineStrip(point3dList2, new Color3f(0.7f, 0.0f, 1.0f)));
                }
                if ((point3dList2 = silhouette2.list()) != null && point3dList2.num() > 1) {
                    point3dIterator = new Point3dIterator(point3dList2);
                    branchGroup.addChild((Node)ShapeMaker.makeLineStrip(point3dList2, new Color3f(0.9f, 0.0f, 0.0f)));
                }
            }
        }
        this._bg.addChild((Node)branchGroup);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void shootRays() {
        Dimension dimension = ((Component)((Object)this._canvas)).getSize();
        Point point = ((Component)((Object)this._canvas)).getLocationOnScreen();
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        Transform3D transform3D = new Transform3D();
        this._canvas.getImagePlateToVworld(transform3D);
        Vector3d vector3d = this._cam.getLook();
        Point3d point3d = new Point3d();
        this._canvas.getCenterEyeInImagePlate(point3d);
        transform3D.transform(point3d);
        Point3d point3d2 = new Point3d();
        int n = 0;
        while (n < dimension.width) {
            int n2 = 0;
            while (n2 < dimension.height) {
                Point3dList point3dList;
                Point3d point3d3 = new Point3d();
                this._canvas.getPixelLocationInImagePlate(n, n2, point3d3);
                transform3D.transform(point3d3);
                boolean bl = this._mt.intersect(point3d3, vector3d, 100.0, point3d2);
                if (bl && (point3dList = this._mt.tracePath(point3d2, vector3d)) != null && point3dList.num() > 1) {
                    this.markEndpt(point3dList, point3d, branchGroup, 0.1);
                }
                n2 += 20;
            }
            n += 20;
        }
        this._bg.addChild((Node)branchGroup);
    }
}

