/*
 * Decompiled with CFR 0.152.
 */
import javax.media.j3d.BranchGroup;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class ModelTracer2 {
    protected Function3D _func;
    protected double _targetval;
    public double _eps_intersect;
    public double _eps_findedge_stepsize;
    public double _eps_findedge_resolution;
    public double _eps_trace_stepsize;
    public double _eps_trace_correctiondist;
    public double[] _eps_default;
    public BranchGroup _bg;
    protected boolean _stop_now;
    protected static final int CCW = 0;
    protected static final int CW = 1;
    private Point3d inter_currpt;
    private Point3d trc_currpt;
    private Vector3d trc_grad;
    private Vector3d trc_next_grad;
    private Vector3d trc_shortjump;
    private Point3d trc_nextpt;
    private Point3d find_currpt;
    private Vector3d find_grad;
    private Vector3d find_next_grad;
    private Vector3d find_shortjump;
    private Point3d find_nextpt;
    private Vector3d prd_grad;
    private Matrix3d prd_hessian_transp;
    private Vector3d prd_hv;
    private Vector3d prd_solution;
    private Vector3d crt_grad;
    private Point3d crt_temppt;
    protected static final int STATE_REACHED_END = 1;
    protected static final int STATE_REACHED_BEGINNING = 2;
    protected static final int STATE_ERROR = 3;
    protected static final int STATE_BROKE_EARLY = 4;

    public ModelTracer2(Function3D function3D) {
        this._func = function3D;
        this._targetval = function3D.getDefaultVal();
        this.initLocalVars();
        this.initEps();
    }

    public ModelTracer2(Function3D function3D, double d) {
        this._func = function3D;
        this._targetval = d;
        this.initLocalVars();
        this.initEps();
    }

    public void canCont() {
        this._stop_now = false;
    }

    public void changeEps(double d) {
        this._eps_intersect *= d;
        this._eps_findedge_stepsize *= d;
        this._eps_findedge_resolution *= d;
        this._eps_trace_stepsize *= d;
        this._eps_trace_correctiondist *= d;
    }

    protected void correct(Point3d point3d, Vector3d vector3d) {
        boolean bl;
        boolean bl2;
        this._func.gradient(point3d, this.crt_grad);
        if (this.lowside(point3d)) {
            bl2 = this.intersect(point3d, this.crt_grad, this._eps_trace_correctiondist, this.crt_temppt);
        } else {
            this.crt_grad.negate();
            bl2 = this.intersect(point3d, this.crt_grad, this._eps_trace_correctiondist, this.crt_temppt);
            this.crt_grad.negate();
        }
        if (!bl2) {
            return;
        }
        point3d.set((Tuple3d)this.crt_temppt);
        this._func.gradient(point3d, this.crt_grad);
        if (this.crt_grad.dot(vector3d) > 0.0) {
            bl = this.newFindSilhPoint(point3d, vector3d, this.crt_temppt);
        } else {
            vector3d.negate();
            bl = this.newFindSilhPoint(point3d, vector3d, this.crt_temppt);
            vector3d.negate();
        }
        if (bl) {
            point3d.set((Tuple3d)this.crt_temppt);
        }
    }

    public boolean dbgintersect(Point3d point3d, Vector3d vector3d, double d, Point3d point3d2) {
        this.inter_currpt.set((Tuple3d)point3d);
        double d2 = this._func.slopeLowBound();
        double d3 = this._func.slopeHighBound();
        double d4 = 123.0;
        double d5 = this._func.eval(point3d);
        double d6 = 0.0;
        double d7 = 1.0;
        vector3d.normalize();
        if (d5 > this._targetval) {
            if (d2 >= 0.0) {
                return false;
            }
            d7 = d2;
        } else if (d5 < this._targetval) {
            if (d3 <= 0.0) {
                return false;
            }
            d7 = d3;
        }
        int n = 0;
        while (d4 > this._eps_intersect && d5 != this._targetval && d6 < d) {
            ++n;
            d4 = (this._targetval - d5) / d7;
            this.inter_currpt.scaleAdd(d4, (Tuple3d)vector3d, (Tuple3d)this.inter_currpt);
            d6 += d4;
            d5 = this._func.eval(this.inter_currpt);
        }
        System.out.println("Num steps:" + n);
        if (d6 < d) {
            point3d2.set((Tuple3d)this.inter_currpt);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void fillinSilh(Silhouette var1_1) {
        var2_2 = var1_1.viewdir();
        var3_3 = this.traceSilhCCW(var1_1.list().getLast(), var2_2, var1_1.list());
        switch (var3_3) {
            case 1: 
            case 3: {
                var4_4 = this.traceSilhCW(var1_1.list().getFirst(), var2_2, var1_1.list());
                if (var4_4 != 1) ** GOTO lbl9
                var1_1.completed();
                ** GOTO lbl13
lbl9:
                // 1 sources

                if (var4_4 == 4) {
                    var1_1.notcompleted();
                } else {
                    var1_1.completed();
                }
            }
lbl13:
            // 4 sources

            case 2: {
                var1_1.completed();
                break;
            }
            case 4: {
                var1_1.notcompleted();
                break;
            }
        }
    }

    public boolean findSilhPoint(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        block5: {
            double d = this._eps_findedge_stepsize;
            this.find_currpt.set((Tuple3d)point3d);
            this._func.gradient(point3d, this.find_grad);
            int n = this.find_grad.dot(vector3d) > 0.0 ? 1 : -1;
            int n2 = 0;
            while (true) {
                boolean bl;
                if (++n2 % 100 == 0) {
                    return false;
                }
                this.find_shortjump.cross(vector3d, this.find_grad);
                this.find_shortjump.cross(this.find_grad, this.find_shortjump);
                this.find_shortjump.normalize();
                this.find_shortjump.scale(d);
                this.find_nextpt.add((Tuple3d)this.find_currpt, (Tuple3d)this.find_shortjump);
                if (this.lowside(this.find_nextpt)) {
                    bl = this.intersect(this.find_nextpt, this.find_grad, 5.0 * d, this.find_nextpt);
                } else {
                    this.find_grad.negate();
                    bl = this.intersect(this.find_nextpt, this.find_grad, 5.0 * d, this.find_nextpt);
                    this.find_grad.negate();
                }
                if (!bl) break;
                this._func.gradient(this.find_nextpt, this.find_next_grad);
                if (this.find_next_grad.dot(vector3d) > 0.0 && n == -1 || this.find_next_grad.dot(vector3d) < 0.0 && n == 1) {
                    if (!((d /= 2.0) < this._eps_findedge_resolution)) continue;
                    break block5;
                }
                this.find_currpt.set((Tuple3d)this.find_nextpt);
                this.find_grad.set((Tuple3d)this.find_next_grad);
            }
            System.out.println("Unusual case");
            return false;
        }
        point3d2.set((Tuple3d)this.find_currpt);
        return true;
    }

    public Function3D getFunc() {
        return this._func;
    }

    public double getTargetVal() {
        return this._targetval;
    }

    public double getTracingStepsize() {
        return this._eps_trace_stepsize;
    }

    public boolean highside(Point3d point3d) {
        return this._func.eval(point3d) > this._targetval;
    }

    protected void initEps() {
        this._eps_default = new double[5];
        this._eps_default[0] = 0.001;
        this._eps_intersect = 0.001;
        this._eps_default[1] = 0.1;
        this._eps_findedge_stepsize = 0.1;
        this._eps_default[2] = 0.005;
        this._eps_findedge_resolution = 0.005;
        this._eps_default[3] = 0.1;
        this._eps_trace_stepsize = 0.1;
        this._eps_default[4] = 0.5;
        this._eps_trace_correctiondist = 0.5;
    }

    private void initLocalVars() {
        this.inter_currpt = new Point3d();
        this.trc_currpt = new Point3d();
        this.trc_grad = new Vector3d();
        this.trc_next_grad = new Vector3d();
        this.trc_shortjump = new Vector3d();
        this.trc_nextpt = new Point3d();
        this.find_currpt = new Point3d();
        this.find_grad = new Vector3d();
        this.find_next_grad = new Vector3d();
        this.find_shortjump = new Vector3d();
        this.find_nextpt = new Point3d();
        this.prd_grad = new Vector3d();
        this.prd_hessian_transp = new Matrix3d();
        this.prd_hv = new Vector3d();
        this.prd_solution = new Vector3d();
        this.crt_grad = new Vector3d();
        this.crt_temppt = new Point3d();
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d, double d, Point3d point3d2) {
        this.inter_currpt.set((Tuple3d)point3d);
        double d2 = this._func.slopeLowBound();
        double d3 = this._func.slopeHighBound();
        double d4 = 123.0;
        double d5 = this._func.eval(point3d);
        double d6 = 0.0;
        double d7 = 1.0;
        vector3d.normalize();
        if (d5 > this._targetval) {
            if (d2 >= 0.0) {
                return false;
            }
            d7 = d2;
        } else if (d5 < this._targetval) {
            if (d3 <= 0.0) {
                return false;
            }
            d7 = d3;
        }
        while (d4 > this._eps_intersect && d5 != this._targetval && d6 < d) {
            d4 = (this._targetval - d5) / d7;
            this.inter_currpt.scaleAdd(d4, (Tuple3d)vector3d, (Tuple3d)this.inter_currpt);
            d6 += d4;
            d5 = this._func.eval(this.inter_currpt);
        }
        if (d6 < d) {
            point3d2.set((Tuple3d)this.inter_currpt);
            return true;
        }
        return false;
    }

    public boolean lowside(Point3d point3d) {
        return this._func.eval(point3d) < this._targetval;
    }

    public boolean newFindSilhPoint(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        block3: {
            double d = this._eps_findedge_stepsize;
            this.find_currpt.set((Tuple3d)point3d);
            this._func.gradient(point3d, this.find_grad);
            int n = this.find_grad.dot(vector3d) > 0.0 ? 1 : -1;
            int n2 = 0;
            while (true) {
                if (++n2 % 100 == 0) {
                    return false;
                }
                double d2 = this.find_grad.lengthSquared();
                this.find_shortjump.scaleAdd(-vector3d.dot(this.find_grad) / d2, (Tuple3d)this.find_grad, (Tuple3d)vector3d);
                this.find_shortjump.normalize();
                this.find_shortjump.scale(d);
                double d3 = 1.0;
                double d4 = -d3 * (this._func.eval(this.find_currpt) - this._targetval) / d2;
                this.find_shortjump.scaleAdd(d4, (Tuple3d)this.find_grad, (Tuple3d)this.find_shortjump);
                this.find_nextpt.add((Tuple3d)this.find_currpt, (Tuple3d)this.find_shortjump);
                boolean bl = true;
                if (!bl) break;
                this._func.gradient(this.find_nextpt, this.find_next_grad);
                if (this.find_next_grad.dot(vector3d) > 0.0 && n == -1 || this.find_next_grad.dot(vector3d) < 0.0 && n == 1) {
                    if (!((d /= 2.0) < this._eps_findedge_resolution)) continue;
                    break block3;
                }
                this.find_currpt.set((Tuple3d)this.find_nextpt);
                this.find_grad.set((Tuple3d)this.find_next_grad);
            }
            System.out.println("Unusual case");
            return false;
        }
        point3d2.set((Tuple3d)this.find_currpt);
        return true;
    }

    public Point3dList newTracePath(Point3d point3d, Vector3d vector3d) {
        Point3dList point3dList;
        block3: {
            point3dList = new Point3dList();
            point3dList.add(point3d);
            double d = this._eps_findedge_stepsize;
            this.trc_currpt.set((Tuple3d)point3d);
            this._func.gradient(point3d, this.trc_grad);
            int n = this.trc_grad.dot(vector3d) > 0.0 ? 1 : -1;
            int n2 = 0;
            while (true) {
                if (++n2 % 100 == 0) {
                    return null;
                }
                double d2 = this.trc_grad.lengthSquared();
                this.trc_shortjump.scaleAdd(-vector3d.dot(this.trc_grad) / d2, (Tuple3d)this.trc_grad, (Tuple3d)vector3d);
                this.trc_shortjump.normalize();
                this.trc_shortjump.scale(d);
                double d3 = 1.0;
                double d4 = -d3 * (this._func.eval(this.trc_currpt) - this._targetval) / d2;
                this.trc_shortjump.scaleAdd(d4, (Tuple3d)this.trc_grad, (Tuple3d)this.trc_shortjump);
                this.trc_nextpt.add((Tuple3d)this.trc_currpt, (Tuple3d)this.trc_shortjump);
                boolean bl = true;
                if (!bl) break;
                this._func.gradient(this.trc_nextpt, this.trc_next_grad);
                if (this.trc_next_grad.dot(vector3d) > 0.0 && n == -1 || this.trc_next_grad.dot(vector3d) < 0.0 && n == 1) {
                    if (!((d /= 2.0) < this._eps_findedge_resolution)) continue;
                    break block3;
                }
                this.trc_currpt.set((Tuple3d)this.trc_nextpt);
                this.trc_grad.set((Tuple3d)this.trc_next_grad);
                point3dList.add(this.trc_currpt);
            }
            System.out.println("Unusual case");
            return null;
        }
        return point3dList;
    }

    protected void predict(Point3d point3d, Vector3d vector3d, int n) {
        this._func.gradient(point3d, this.prd_grad);
        this._func.hessian(point3d, this.prd_hessian_transp);
        this.prd_hessian_transp.transform((Tuple3d)vector3d, (Tuple3d)this.prd_hv);
        if (n == 0) {
            this.prd_solution.cross(this.prd_hv, this.prd_grad);
        } else {
            this.prd_solution.cross(this.prd_grad, this.prd_hv);
        }
        this.prd_solution.normalize();
        this.prd_solution.scale(this._eps_trace_stepsize);
        double d = this.prd_grad.lengthSquared();
        double d2 = 1.0;
        double d3 = -d2 * (this._func.eval(point3d) - this._targetval) / d;
        this.prd_solution.scaleAdd(d3, (Tuple3d)this.prd_grad, (Tuple3d)this.prd_solution);
        double d4 = 0.0;
        double d5 = -d4 * vector3d.dot(this.prd_grad) / d;
        this.prd_solution.scaleAdd(d5, (Tuple3d)this.prd_hv, (Tuple3d)this.prd_solution);
        point3d.add((Tuple3d)this.prd_solution);
    }

    public void setEps(double d) {
        this._eps_intersect = this._eps_default[0] * d;
        this._eps_findedge_stepsize = this._eps_default[1] * d;
        this._eps_findedge_resolution = this._eps_default[2] * d;
        this._eps_trace_stepsize = this._eps_default[3] * d;
        this._eps_trace_correctiondist = this._eps_default[4] * d;
        System.out.println("New Stepsize: " + this._eps_trace_stepsize);
    }

    public void setFunc(Function3D function3D) {
        this._func = function3D;
        this._targetval = this._func.getDefaultVal();
    }

    public void setTargetVal(double d) {
        this._targetval = d;
    }

    public void stopNow() {
        this._stop_now = true;
    }

    public Point3dList tracePath(Point3d point3d, Vector3d vector3d) {
        Point3dList point3dList;
        block5: {
            point3dList = new Point3dList();
            point3dList.add(point3d);
            double d = this._eps_findedge_stepsize;
            this.trc_currpt.set((Tuple3d)point3d);
            this._func.gradient(point3d, this.trc_grad);
            int n = this.trc_grad.dot(vector3d) > 0.0 ? 1 : -1;
            int n2 = 0;
            while (true) {
                boolean bl;
                if (++n2 % 100 == 0) {
                    return null;
                }
                this.trc_shortjump.cross(vector3d, this.trc_grad);
                this.trc_shortjump.cross(this.trc_grad, this.trc_shortjump);
                this.trc_shortjump.normalize();
                this.trc_shortjump.scale(d);
                this.trc_nextpt.add((Tuple3d)this.trc_currpt, (Tuple3d)this.trc_shortjump);
                if (this.lowside(this.trc_nextpt)) {
                    bl = this.intersect(this.trc_nextpt, this.trc_grad, 2.0 * d, this.trc_nextpt);
                } else {
                    this.trc_grad.negate();
                    bl = this.intersect(this.trc_nextpt, this.trc_grad, 2.0 * d, this.trc_nextpt);
                    this.trc_grad.negate();
                }
                if (!bl) break;
                this._func.gradient(this.trc_nextpt, this.trc_next_grad);
                if (this.trc_next_grad.dot(vector3d) > 0.0 && n == -1 || this.trc_next_grad.dot(vector3d) < 0.0 && n == 1) {
                    if (!((d /= 2.0) < this._eps_findedge_resolution)) continue;
                    break block5;
                }
                this.trc_currpt.set((Tuple3d)this.trc_nextpt);
                this.trc_grad.set((Tuple3d)this.trc_next_grad);
                point3dList.add(this.trc_currpt);
            }
            System.out.println("Unusual case");
            return null;
        }
        return point3dList;
    }

    public Silhouette traceSilh(Point3d point3d, Vector3d vector3d) {
        Silhouette silhouette = new Silhouette();
        silhouette.list().add(point3d);
        silhouette.setViewdir(vector3d);
        int n = this.traceSilhCCW(point3d, vector3d, silhouette.list());
        switch (n) {
            case 1: 
            case 3: {
                int n2 = this.traceSilhCW(point3d, vector3d, silhouette.list());
                if (n2 == 1) {
                    silhouette.completed();
                    break;
                }
                if (n2 == 4) {
                    silhouette.notcompleted();
                    break;
                }
                silhouette.completed();
                break;
            }
            case 2: {
                silhouette.completed();
                break;
            }
            case 4: {
                silhouette.notcompleted();
                break;
            }
        }
        return silhouette;
    }

    protected int traceSilhCCW(Point3d point3d, Vector3d vector3d, Point3dList point3dList) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d(point3d);
        int n = 0;
        while (n < 500) {
            if (this._stop_now) {
                System.out.println("MT: stop_now = true");
                return 4;
            }
            if (n % 20 == 0) {
                Thread.yield();
            }
            this.predict(point3d3, vector3d, 0);
            point3d2.set((Tuple3d)point3d3);
            if (n % 10 == 0) {
                this.correct(point3d3, vector3d);
            }
            if (point3d3.distance(point3d2) > 2.0 * this._eps_trace_stepsize) {
                return 1;
            }
            if (point3d3.distance(point3dList.getFirst()) < this._eps_trace_stepsize && n > 1) {
                point3dList.add(point3dList.getFirst());
                return 2;
            }
            point3dList.add(point3d3);
            ++n;
        }
        System.out.println("runaway tracing");
        return 3;
    }

    protected int traceSilhCW(Point3d point3d, Vector3d vector3d, Point3dList point3dList) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d(point3d);
        int n = 0;
        while (n < 500) {
            if (this._stop_now) {
                return 4;
            }
            if (n % 20 == 0) {
                Thread.yield();
            }
            this.predict(point3d3, vector3d, 1);
            point3d2.set((Tuple3d)point3d3);
            if (n % 10 == 0) {
                this.correct(point3d3, vector3d);
            }
            if (point3d3.distance(point3d2) > 2.0 * this._eps_trace_stepsize) {
                return 1;
            }
            if (point3d3.distance(point3dList.getLast()) < this._eps_trace_stepsize && n > 1) {
                point3dList.prepend(point3dList.getLast());
                return 2;
            }
            point3dList.prepend(point3d3);
            ++n;
        }
        System.out.println("runaway tracing");
        return 3;
    }
}

