/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class ImplCanvas3D
extends Canvas3D
implements CamListener {
    protected boolean _cam_has_rotated = false;
    protected boolean _cam_has_moved = false;
    protected boolean _first_time = true;
    protected boolean _draw_switch = true;
    protected long _time_to_complete = 200L;
    protected Color3f _background_color = new Color3f(1.0f, 1.0f, 1.0f);
    protected Color3f _foreground_color = new Color3f(0.0f, 0.0f, 0.6f);
    protected Function3D _new_func;
    protected boolean _update_func = false;
    protected BlobbyModel _new_model;
    protected boolean _show_model;
    protected boolean _update_targetval = false;
    protected double _new_targetval;
    protected Transform3D _vw2ip = new Transform3D();
    protected Transform3D _ip2vw = new Transform3D();
    protected EdgeFinder _edge_finder = null;
    protected EdgeProcessor _edge_proc = null;
    protected MouseInteractor _mouse_int;
    protected BlobbyModel _model;
    protected Function3D _func;
    public TrackballCamera _cam;
    protected long framecount = 0L;

    public ImplCanvas3D() {
        super(null);
    }

    public Color3f backgroundColor() {
        return this._background_color;
    }

    public void camMoved(int n) {
        this._cam_has_moved = true;
        if (n == 1) {
            this._cam_has_rotated = true;
        }
    }

    public void distributeFunc(Function3D function3D, BlobbyModel blobbyModel) {
        this._new_func = function3D;
        this._new_model = blobbyModel;
        this._update_func = true;
    }

    public Color3f foregroundColor() {
        return this._foreground_color;
    }

    public void projectPoint(Point3d point3d) {
        this.getVworldToImagePlate(this._vw2ip);
        this.getImagePlateToVworld(this._ip2vw);
        this._vw2ip.transform(point3d);
        point3d.set(point3d.x, point3d.y, 0.0);
        this._ip2vw.transform(point3d);
    }

    public void renderField(int n) {
        if (!this._draw_switch) {
            this._edge_finder.stop();
            this._edge_proc.stop();
            GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
            this._edge_proc.draw(graphicsContext3D);
            if (this._cam_has_moved) {
                this._cam.updateCamera();
                this._cam_has_rotated = false;
                this._cam_has_moved = false;
            }
            this._edge_finder._trial_points.clear();
            return;
        }
        if (this._first_time) {
            this._edge_finder.camChanged(true);
            this._edge_proc.camChanged(true);
            this._first_time = false;
        }
        long l = new Date().getTime();
        GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
        this._edge_finder.pause();
        this._edge_finder.accessLock().lock();
        this._edge_proc.draw(graphicsContext3D);
        if (this._show_model) {
            this._model.draw(graphicsContext3D);
        }
        this._model.update();
        if (this._update_targetval) {
            this._edge_finder.setTargetVal(this._new_targetval);
            this._edge_proc.setTargetVal(this._new_targetval);
            this._update_targetval = false;
            this._edge_finder.camChanged(true);
            this._edge_proc.camChanged(true);
        }
        if (this._update_func) {
            this._edge_finder.setFunc(this._new_func);
            this._edge_proc.setFunc(this._new_func);
            this._edge_finder.camChanged(true);
            this._edge_proc.camChanged(true);
            this._model = this._new_model;
            this._func = this._new_func;
            this._update_func = false;
        }
        if (this._cam_has_moved) {
            this._cam.updateCamera();
            this._edge_finder.camChanged(this._cam_has_rotated);
            this._edge_proc.camChanged(this._cam_has_rotated);
            this._cam_has_rotated = false;
            this._cam_has_moved = false;
        }
        this._edge_finder.cont();
        this._edge_finder.accessLock().unlock();
        Thread.yield();
        try {
            Thread.sleep(this._time_to_complete);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void requestFramesPerSecond(int n) {
        double d = 1000.0 / (double)n;
        this._time_to_complete = Math.round(d * 0.9);
        System.out.println("fps " + n + " ms " + this._time_to_complete);
    }

    public void setDrawingEnabled(boolean bl) {
        this._draw_switch = bl;
    }

    public void setEdgeFinder(EdgeFinder edgeFinder) {
        this._edge_finder = edgeFinder;
    }

    public void setEdgeProcessor(EdgeProcessor edgeProcessor) {
        this._edge_proc = edgeProcessor;
    }

    public void setFunction(Function3D function3D) {
        this._func = function3D;
    }

    public void setModel(BlobbyModel blobbyModel) {
        this._model = blobbyModel;
    }

    public void setMouseInteractor(MouseInteractor mouseInteractor) {
        this._mouse_int = mouseInteractor;
    }

    public void showModel(boolean bl) {
        this._show_model = bl;
    }

    public void updateTargetVal(double d) {
        this._new_targetval = d;
        this._update_targetval = true;
    }

    public Vector3d viewdir() {
        return this._edge_finder.viewdir();
    }
}

