/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

class EdgeProcessor
extends Thread {
    protected Function3D _func;
    protected ModelTracer _mt;
    protected Transform3D _vw_to_ip;
    protected SilhEdgeList _edges;
    protected LineHashTable _table;
    protected long _framenum;
    protected SilhouetteList _new_edges;
    protected SilhouetteList _partial_edges;
    protected Color3f[] _color;
    protected boolean _has_paused;
    protected Mutex _access_lock;
    protected Point3dList _heur_pts;
    protected Shape3DList _shade_list;
    protected Transform3D _vis_vw2ip = new Transform3D();
    protected Transform3D _vis_ip2vw = new Transform3D();
    protected Point3d _vis_pt = new Point3d();
    protected Vector3d _vis_vec = new Vector3d();
    protected Point3d _hit_pt = new Point3d();
    protected Appearance _ap = new Appearance();
    protected ImplCanvas3D _canvas;
    protected EdgeFinder _edge_finder;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 1;
    public static final int VIS_UNKNOWN = 2;

    public EdgeProcessor(Function3D function3D) {
        super("EdgeProcessor");
        this.setDaemon(true);
        this.setPriority(10);
        this._func = function3D;
        this._mt = new ModelTracer(function3D);
        this._vw_to_ip = new Transform3D();
        this._edges = new SilhEdgeList();
        this._new_edges = new SilhouetteList();
        this._partial_edges = new SilhouetteList();
        this._has_paused = false;
        this._color = new Color3f[6];
        this._color[0] = new Color3f(0.0f, 0.0f, 7.0f);
        this._color[1] = new Color3f(0.7f, 0.7f, 0.0f);
        this._color[2] = new Color3f(0.0f, 0.7f, 0.0f);
        this._color[3] = new Color3f(0.9f, 0.4f, 0.0f);
        this._color[4] = new Color3f(0.7f, 0.0f, 0.0f);
        this._color[5] = new Color3f(0.7f, 0.0f, 1.0f);
        this._access_lock = new Mutex();
        this._heur_pts = new Point3dList();
        this._shade_list = new Shape3DList();
    }

    public synchronized void addNewEdge(Silhouette silhouette) {
        this._new_edges.add(silhouette);
        this._has_paused = false;
        if (!silhouette.isComplete()) {
            this._partial_edges.add(silhouette);
        }
        this.notify();
    }

    public void camChanged(boolean bl) {
        if (bl) {
            this._edge_finder.clearHeuristics();
            Point3dIterator point3dIterator = new Point3dIterator(this._heur_pts);
            point3dIterator.init();
            while (!point3dIterator.isDone()) {
                this._edge_finder.addNewHeuristic(new Heuristic(point3dIterator.curr()));
                point3dIterator.incr();
            }
            this._heur_pts.clear();
            this.canvasChanged();
            this.clear();
        }
    }

    public void canvasChanged() {
        this._canvas.getVworldToImagePlate(this._vw_to_ip);
    }

    public void clear() {
        this._edges.clear();
        this._heur_pts.clear();
        this._new_edges.clear();
        this._partial_edges.clear();
        this._shade_list.clear();
        this.canvasChanged();
    }

    public void detectIntersections(Silhouette silhouette) {
        SilhEdge silhEdge = new SilhEdge(silhouette, this._vw_to_ip, this._heur_pts);
        this._edges.add(silhEdge);
        Point3d point3d = new Point3d();
        int n = 1;
        while (n < silhEdge.len()) {
            int n2 = 0;
            while (n2 < n) {
                LineSeg2d lineSeg2d;
                LineSeg2d lineSeg2d2 = silhEdge.getScreenEdge(n);
                int n3 = LineSeg2d.intersect(lineSeg2d2, lineSeg2d = silhEdge.getScreenEdge(n2), point3d);
                if (n3 != 0) {
                    System.out.println("crossed at " + point3d);
                    System.out.println(String.valueOf(n2) + "  " + n);
                    Point point = new Point();
                    this._table.ip2grid(lineSeg2d2.v1(), point);
                    System.out.println(point);
                    this._table.ip2grid(lineSeg2d2.v2(), point);
                    System.out.println(point);
                    this._table.ip2grid(lineSeg2d.v1(), point);
                    System.out.println(point);
                    this._table.ip2grid(lineSeg2d.v2(), point);
                    System.out.println(point);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void draw(GraphicsContext3D graphicsContext3D) {
        Thread.yield();
        this._access_lock.lock();
        SilhEdgeIterator silhEdgeIterator = new SilhEdgeIterator(this._edges);
        silhEdgeIterator.init();
        int n = 0;
        while (!silhEdgeIterator.isDone()) {
            silhEdgeIterator.curr().draw(graphicsContext3D);
            ++n;
            silhEdgeIterator.incr();
        }
        SilhouetteIterator silhouetteIterator = new SilhouetteIterator(this._partial_edges);
        silhouetteIterator.init();
        while (!silhouetteIterator.isDone()) {
            this._edge_finder.prependNewHeuristic(new Heuristic(silhouetteIterator.curr()));
            silhouetteIterator.incr();
        }
        this._partial_edges.clear();
        Shape3DIterator shape3DIterator = new Shape3DIterator(this._shade_list);
        shape3DIterator.init();
        while (!shape3DIterator.isDone()) {
            graphicsContext3D.draw(shape3DIterator.curr());
            shape3DIterator.incr();
        }
        Point3dList point3dList = this._edge_finder.visSurfacePts();
        if (this._func != null && point3dList.num() != 0) {
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            Point3d point3d = new Point3d();
            Point3d point3d2 = new Point3d();
            Color3f color3f = new Color3f();
            this._edge_finder.viewdir().normalize();
            LineArray lineArray = new LineArray(point3dList.num() * 2, 5);
            int n2 = 0;
            Point3dIterator point3dIterator = new Point3dIterator(point3dList);
            point3dIterator.init();
            while (!point3dIterator.isDone()) {
                point3d.set((Tuple3d)point3dIterator.curr());
                point3d2.set((Tuple3d)point3dIterator.curr());
                this._func.gradient(point3dIterator.curr(), vector3d);
                vector3d2.cross(vector3d, this._edge_finder.viewdir());
                vector3d2.normalize();
                vector3d2.scale(0.05);
                point3d.add((Tuple3d)vector3d2);
                point3d2.sub((Tuple3d)vector3d2);
                vector3d.normalize();
                double d = vector3d.dot(this._edge_finder.viewdir());
                d = Math.abs(d);
                d = 0.9 * d + 0.1;
                color3f.set((Tuple3f)this._canvas.foregroundColor());
                color3f.scale((float)(1.0 - d));
                color3f.scaleAdd((float)d, (Tuple3f)this._canvas.backgroundColor(), (Tuple3f)color3f);
                lineArray.setCoordinate(n2, point3d);
                lineArray.setCoordinate(n2 + 1, point3d2);
                lineArray.setColor(n2, color3f);
                lineArray.setColor(n2 + 1, color3f);
                point3dIterator.incr();
                n2 += 2;
            }
            Shape3D shape3D = new Shape3D((Geometry)lineArray, this._ap);
            graphicsContext3D.draw(shape3D);
            this._shade_list.add(shape3D);
            point3dList.clear();
        }
        this._access_lock.unlock();
    }

    public ImplCanvas3D getCanvas() {
        return this._canvas;
    }

    public boolean hasPaused() {
        return this._has_paused;
    }

    public boolean isVisible(Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        vector3d2.normalize();
        this._vis_pt.set((Tuple3d)point3d);
        this._vis_pt.scaleAdd(-20.0, (Tuple3d)vector3d2, (Tuple3d)this._vis_pt);
        this._vis_vec.sub((Tuple3d)point3d, (Tuple3d)this._vis_pt);
        boolean bl = this._mt.intersect(this._vis_pt, this._vis_vec, 100.0, this._hit_pt);
        if (bl) {
            boolean bl2 = point3d.distanceSquared(this._hit_pt) < this._mt._eps_intersect * 500.0;
            return bl2;
        }
        this._vis_pt.scaleAdd(10.0, (Tuple3d)vector3d2, (Tuple3d)this._vis_pt);
        return true;
    }

    public synchronized Silhouette removeFirstEdge() {
        try {
            while (this._new_edges.num() == 0) {
                this._has_paused = true;
                this._access_lock.unlock();
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {}
        this._access_lock.lock();
        Silhouette silhouette = this._new_edges.getFirst();
        this._new_edges.remove(silhouette);
        return silhouette;
    }

    public void run() {
        while (true) {
            Silhouette silhouette = this.removeFirstEdge();
            SilhEdge silhEdge = new SilhEdge(silhouette, this._vw_to_ip, this._heur_pts);
            Point3d[] point3dArray = silhEdge.worldPts();
            boolean bl = this.isVisible(point3dArray[0], silhouette.viewdir());
            int n = 0;
            while (n < point3dArray.length) {
                boolean bl2 = this.isVisible(point3dArray[n], silhouette.viewdir());
                silhEdge.setVis(n, bl2);
                if (bl != bl2) {
                    boolean bl3;
                    boolean bl4 = this.isVisible(point3dArray[n - 2], silhouette.viewdir());
                    silhEdge.setVis(n - 2, bl4);
                    if (bl4 == bl) {
                        bl3 = this.isVisible(point3dArray[n - 1], silhouette.viewdir());
                        silhEdge.setVis(n - 1, bl4);
                    } else {
                        bl3 = this.isVisible(point3dArray[n - 3], silhouette.viewdir());
                        silhEdge.setVis(n - 3, bl4);
                    }
                }
                bl = bl2;
                n += 4;
            }
            if (silhEdge.shade()) {
                Matrix3d matrix3d = new Matrix3d();
                Vector3d vector3d = new Vector3d();
                Vector3d vector3d2 = new Vector3d();
                Vector3d vector3d3 = new Vector3d();
                Vector3d vector3d4 = new Vector3d();
                Vector3d vector3d5 = new Vector3d();
                Vector3d vector3d6 = new Vector3d();
                int n2 = 0;
                while (n2 < point3dArray.length) {
                    if (n2 != point3dArray.length - 1) {
                        vector3d4.sub((Tuple3d)point3dArray[n2 + 1], (Tuple3d)point3dArray[n2]);
                        vector3d4.normalize();
                    }
                    this._func.gradient(point3dArray[n2], vector3d2);
                    this._func.hessian(point3dArray[n2], matrix3d);
                    vector3d5.cross(vector3d4, vector3d2);
                    vector3d6.set((Tuple3d)vector3d5);
                    matrix3d.transform((Tuple3d)vector3d5);
                    double d = 0.05 * vector3d2.length() / vector3d5.length();
                    vector3d3.cross(silhouette.viewdir(), vector3d4);
                    vector3d3.normalize();
                    vector3d3.scale(d);
                    silhEdge.setOffset(n2, vector3d3);
                    ++n2;
                }
            }
            this._edges.add(silhEdge);
        }
    }

    public void setCanvas(ImplCanvas3D implCanvas3D) {
        this._canvas = implCanvas3D;
    }

    public void setEdgeFinder(EdgeFinder edgeFinder) {
        this._edge_finder = edgeFinder;
    }

    public void setFunc(Function3D function3D) {
        this._func = function3D;
        this._mt.setFunc(function3D);
    }

    public void setTargetVal(double d) {
        this._mt.setTargetVal(d);
    }

    public void viewChanged() {
        this._canvas.getVworldToImagePlate(this._vw_to_ip);
        ++this._framenum;
        this._edges.clear();
        this._new_edges.clear();
    }
}

