/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class EdgeFinder
extends Thread {
    public BranchGroup _bg;
    public Point3dList _trial_points = new Point3dList();
    public Point3dList _reused_points = new Point3dList();
    protected ModelTracer _mt;
    protected Point3dCache _pt_cache;
    protected Vector3d _viewdir;
    protected boolean _redraw_required;
    protected boolean _cam_rotated;
    protected HeuristicList _hlist;
    protected Mutex _hlist_lock;
    protected Transform3D _vw2ip;
    protected Transform3D _ip2vw;
    protected boolean _pause;
    public boolean _has_paused;
    protected Mutex _access_lock;
    protected Point3dList _vis_surface_pts;
    protected TrackballCamera _cam;
    protected ImplCanvas3D _canvas;
    protected EdgeProcessor _edge_proc;

    EdgeFinder(Function3D function3D, TrackballCamera trackballCamera) {
        super("EdgeFinder");
        this.setDaemon(true);
        this._mt = new ModelTracer(function3D);
        this._cam = trackballCamera;
        this._redraw_required = true;
        this._cam_rotated = true;
        this._pause = false;
        this._has_paused = false;
        this._pt_cache = new Point3dCache(this._mt.getTracingStepsize());
        this._hlist = new HeuristicList();
        this._vw2ip = new Transform3D();
        this._ip2vw = new Transform3D();
        this._viewdir = new Vector3d();
        this._hlist_lock = new Mutex();
        this._access_lock = new Mutex();
        this._vis_surface_pts = new Point3dList();
    }

    public Mutex accessLock() {
        return this._access_lock;
    }

    public void addNewHeuristic(Heuristic heuristic) {
        this._hlist_lock.lock();
        this._hlist.add(heuristic);
        this._hlist_lock.unlock();
    }

    public void camChanged(boolean bl) {
        this._redraw_required = true;
        this._cam_rotated = bl;
    }

    public void clearHeuristics() {
        this._hlist_lock.lock();
        this._hlist.clear();
        this._hlist_lock.unlock();
    }

    public void cont() {
        this._mt.canCont();
        this._pause = false;
        this._has_paused = false;
    }

    protected Silhouette findEdge(Point3d point3d, Vector3d vector3d, Vector3d vector3d2) {
        Point3d point3d2 = new Point3d();
        boolean bl = this._mt.intersect(point3d, vector3d, 100.0, point3d2);
        if (bl) {
            this._vis_surface_pts.add(point3d2);
            Point3d point3d3 = new Point3d();
            boolean bl2 = this._mt.newFindSilhPoint(point3d2, vector3d2, point3d3);
            if (bl2) {
                if (this._pt_cache.proximityTest(point3d3)) {
                    return null;
                }
                Silhouette silhouette = this._mt.traceSilh(point3d3, vector3d2);
                return silhouette;
            }
        }
        return null;
    }

    public ImplCanvas3D getCanvas() {
        return this._canvas;
    }

    public EdgeProcessor getEdgeProcessor() {
        return this._edge_proc;
    }

    public boolean hasPaused() {
        return this._has_paused;
    }

    protected Point3d imgToWorld(int n, int n2) {
        Point3d point3d = new Point3d();
        this._canvas.getPixelLocationInImagePlate(n, n2, point3d);
        Transform3D transform3D = new Transform3D();
        this._canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        return point3d;
    }

    public void intervalSizeChanged() {
        this._pt_cache.setInterval(this._mt.getTracingStepsize());
        this._redraw_required = true;
    }

    public void pause() {
        this._pause = true;
    }

    public void prependNewHeuristic(Heuristic heuristic) {
        this._hlist_lock.lock();
        this._hlist.prepend(heuristic);
        this._hlist_lock.unlock();
    }

    public Heuristic removeFirstHeuristic() {
        this._hlist_lock.lock();
        if (this._hlist.num() == 0) {
            this._hlist_lock.unlock();
            return null;
        }
        Heuristic heuristic = this._hlist.getFirst();
        this._hlist.remove(heuristic);
        this._hlist_lock.unlock();
        return heuristic;
    }

    public void run() {
        block5: while (true) {
            Silhouette silhouette;
            Object object;
            Object object2;
            Heuristic heuristic;
            if (this._pause && this._hlist.num() == 0) {
                this._has_paused = true;
                this._access_lock.unlock();
                this._access_lock.lock();
            }
            if (this._redraw_required) {
                if (this._cam_rotated) {
                    this._pt_cache.clear();
                    this._vis_surface_pts.clear();
                    this._viewdir.set(0.0, 0.0, -1.0);
                    heuristic = new Transform3D();
                    this._cam.getTransform().getTransform((Transform3D)heuristic);
                    heuristic.transform(this._viewdir);
                    this._viewdir.normalize();
                }
                this._trial_points.clear();
                this._reused_points.clear();
                this._redraw_required = false;
                this._cam_rotated = false;
            }
            this._canvas.getVworldToImagePlate(this._vw2ip);
            this._canvas.getImagePlateToVworld(this._ip2vw);
            heuristic = this.removeFirstHeuristic();
            Vector3d vector3d = new Vector3d();
            if (heuristic != null) {
                object2 = new Point3d();
                switch (heuristic.type()) {
                    default: {
                        continue block5;
                    }
                    case 0: {
                        object = heuristic.sil();
                        this._mt.fillinSilh((Silhouette)object);
                        this._edge_proc.addNewEdge((Silhouette)object);
                        if (!((Silhouette)object).isComplete()) continue block5;
                        this._pt_cache.add(((Silhouette)object).list());
                        continue block5;
                    }
                    case 1: {
                        this._reused_points.add(heuristic.pt3());
                        object2.set((Tuple3d)heuristic.pt3());
                        this._vw2ip.transform(object2);
                        object2.set(object2.x, object2.y, 0.0);
                        this._ip2vw.transform(object2);
                        vector3d.sub((Tuple3d)heuristic.pt3(), (Tuple3d)object2);
                        silhouette = this.findEdge((Point3d)object2, vector3d, this._viewdir);
                        if (silhouette == null || silhouette.list().num() <= 1) continue block5;
                        this._edge_proc.addNewEdge(silhouette);
                        if (!silhouette.isComplete()) continue block5;
                        this._pt_cache.add(silhouette.list());
                        continue block5;
                    }
                    case 2: 
                }
                int n = Math.round(heuristic.pt2().x);
                int n2 = Math.round(heuristic.pt2().y);
                this._canvas.getPixelLocationInImagePlate(n, n2, (Point3d)object2);
                this._ip2vw.transform(object2);
                vector3d.set((Tuple3d)this._viewdir);
                silhouette = this.findEdge((Point3d)object2, vector3d, vector3d);
                if (silhouette == null || silhouette.list().num() <= 1) continue;
                this._edge_proc.addNewEdge(silhouette);
                if (!silhouette.isComplete()) continue;
                this._pt_cache.add(silhouette.list());
                continue;
            }
            object2 = ((Component)((Object)this._canvas)).getSize();
            object = new Point3d();
            long l = Math.round((double)object2.width * Math.random());
            long l2 = Math.round((double)object2.height * Math.random());
            this._canvas.getPixelLocationInImagePlate((int)l, (int)l2, (Point3d)object);
            this._ip2vw.transform((Point3d)object);
            vector3d.set((Tuple3d)this._viewdir);
            silhouette = this.findEdge((Point3d)object, vector3d, vector3d);
            if (silhouette != null && silhouette.list().num() > 1) {
                this._edge_proc.addNewEdge(silhouette);
                if (silhouette.isComplete()) {
                    this._pt_cache.add(silhouette.list());
                }
            }
            this._trial_points.add((Point3d)object);
        }
    }

    public void setCanvas(ImplCanvas3D implCanvas3D) {
        this._canvas = implCanvas3D;
    }

    public void setEdgeProcessor(EdgeProcessor edgeProcessor) {
        this._edge_proc = edgeProcessor;
    }

    public void setEps(double d) {
        this._mt.setEps(d);
    }

    public void setFunc(Function3D function3D) {
        this._mt.setFunc(function3D);
        this._hlist.clear();
    }

    public void setTargetVal(double d) {
        this._mt.setTargetVal(d);
    }

    public Vector3d viewdir() {
        return this._viewdir;
    }

    public Point3dList visSurfacePts() {
        return this._vis_surface_pts;
    }
}

