/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class BlobbyModel {
    protected Vector _positions;
    protected Vector _nodes;
    protected Vector _bgs;
    protected BranchGroup _bg;
    protected double _def_rad = 0.15;
    protected Appearance _ap;
    protected Intersector _i;
    protected int _selected;
    protected Point3d _downpt;
    protected Vector3d _deltasum;
    protected BlobList _new_blobs;
    protected boolean _delete_selection;
    protected boolean _increase_influence;
    protected boolean _decrease_influence;
    protected boolean _negate_influence;
    protected BlobbyFunction3D _func;
    protected Illus3D _illus;

    BlobbyModel(BlobbyFunction3D blobbyFunction3D, Illus3D illus3D) {
        this._func = blobbyFunction3D;
        this._illus = illus3D;
        this._i = new Intersector();
        this._selected = -1;
        this._downpt = new Point3d();
        this._deltasum = new Vector3d(0.0, 0.0, 0.0);
        BlobList blobList = this._func.getList();
        this._positions = new Vector(blobList.num(), 5);
        this._positions.setSize(blobList.num());
        int n = 0;
        BlobIterator blobIterator = new BlobIterator(blobList);
        blobIterator.init();
        while (!blobIterator.isDone()) {
            this._positions.setElementAt(new Transform3D(new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), new Vector3d((Tuple3d)blobIterator.curr()._point), this._def_rad * blobIterator.curr()._rad), n);
            blobIterator.incr();
            ++n;
        }
        this._nodes = new Vector(blobList.num(), 5);
        this._nodes.setSize(blobList.num());
        this._bgs = new Vector(blobList.num(), 5);
        this._bgs.setSize(blobList.num());
        this._new_blobs = new BlobList();
        Color3f color3f = new Color3f(0.1f, 0.1f, 0.1f);
        Color3f color3f2 = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f color3f3 = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f color3f4 = new Color3f(0.0f, 0.0f, 0.0f);
        Point3f point3f = new Point3f(1.0f, 0.0f, 0.0f);
        Material material = new Material(color3f, color3f2, color3f3, color3f4, 0.8f);
        this._ap = new Appearance();
        material.setLightingEnable(true);
        this._ap.setMaterial(material);
        this._delete_selection = false;
        this._increase_influence = false;
        this._decrease_influence = false;
        this._negate_influence = false;
    }

    public void click(Point3d point3d, MouseEvent mouseEvent) {
        System.out.println(point3d);
        if (mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && this._selected != -1) {
            this._increase_influence = true;
        } else if (mouseEvent.isControlDown() && !mouseEvent.isShiftDown() && this._selected != -1) {
            this._decrease_influence = true;
        } else if (mouseEvent.isControlDown() && mouseEvent.isShiftDown()) {
            this._negate_influence = true;
        } else if (this._selected == -1) {
            System.out.println("Adding new blob");
            Blob blob = new Blob(point3d, 1.0);
            this._new_blobs.add(blob);
        } else {
            this._delete_selection = true;
        }
    }

    public void draw(GraphicsContext3D graphicsContext3D) {
        Color3f color3f = new Color3f(0.5f, 0.0f, 0.0f);
        LineArray lineArray = new LineArray(4, 5);
        lineArray.setColor(0, color3f);
        lineArray.setColor(1, color3f);
        lineArray.setColor(2, color3f);
        lineArray.setColor(3, color3f);
        Point3d point3d = new Point3d();
        BlobIterator blobIterator = new BlobIterator(this._func.getList());
        blobIterator.init();
        while (!blobIterator.isDone()) {
            point3d.set((Tuple3d)blobIterator.curr()._point);
            double d = blobIterator.curr()._rad * 0.15 * 0.707;
            lineArray.setCoordinate(0, new Point3d(point3d.x + d, 0.0, point3d.z + d));
            lineArray.setCoordinate(1, new Point3d(point3d.x - d, 0.0, point3d.z - d));
            lineArray.setCoordinate(2, new Point3d(point3d.x + d, 0.0, point3d.z - d));
            lineArray.setCoordinate(3, new Point3d(point3d.x - d, 0.0, point3d.z + d));
            graphicsContext3D.draw(new Shape3D((Geometry)lineArray, new Appearance()));
            blobIterator.incr();
        }
    }

    BranchGroup makeBranchGroup() {
        BranchGroup branchGroup = new BranchGroup();
        int n = 0;
        while (n < this._positions.size()) {
            TransformGroup transformGroup = new TransformGroup((Transform3D)this._positions.elementAt(n));
            transformGroup.addChild((Node)new Sphere(1.0f, 1, 10, this._ap));
            transformGroup.setCapability(18);
            transformGroup.setCapability(17);
            BranchGroup branchGroup2 = new BranchGroup();
            branchGroup2.setCapability(17);
            branchGroup2.addChild((Node)transformGroup);
            this._nodes.setElementAt(transformGroup, n);
            this._bgs.setElementAt(branchGroup2, n);
            branchGroup.addChild((Node)branchGroup2);
            ++n;
        }
        branchGroup.setCapability(14);
        branchGroup.setCapability(13);
        branchGroup.setCapability(12);
        this._bg = branchGroup;
        return branchGroup;
    }

    public void notify(Vector3d vector3d) {
        if (this._selected != -1) {
            this._deltasum.add((Tuple3d)vector3d);
        }
    }

    public Point3d select(Point3d point3d, Vector3d vector3d) {
        this._selected = -1;
        double d = Double.MAX_VALUE;
        Transform3D transform3D = new Transform3D();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        int n = 0;
        while (n < this._positions.size()) {
            transform3D.invert((Transform3D)this._positions.elementAt(n));
            point3d2.set((Tuple3d)point3d);
            transform3D.transform(point3d2);
            vector3d2.set((Tuple3d)vector3d);
            transform3D.transform(vector3d2);
            double d2 = this._i.intersect(point3d2, vector3d2, 3, null);
            if (d2 != -1.0 && d2 < d) {
                d = d2;
                this._selected = n;
            }
            ++n;
        }
        if (this._selected == -1) {
            return null;
        }
        Point3d point3d3 = new Point3d(point3d);
        point3d3.scaleAdd(d, (Tuple3d)vector3d, (Tuple3d)point3d3);
        return point3d3;
    }

    public void update() {
        BlobIterator blobIterator;
        Object object;
        if (!(!this._deltasum.equals((Tuple3d)new Vector3d(0.0, 0.0, 0.0)) || this._new_blobs.num() != 0 || this._delete_selection || this._increase_influence || this._decrease_influence || this._negate_influence)) {
            return;
        }
        if (!this._deltasum.equals((Tuple3d)new Vector3d(0.0, 0.0, 0.0))) {
            object = new Transform3D();
            object.set(this._deltasum);
            ((Transform3D)this._positions.elementAt(this._selected)).mul((Transform3D)object, (Transform3D)this._positions.elementAt(this._selected));
            ((TransformGroup)this._nodes.elementAt(this._selected)).setTransform((Transform3D)this._positions.elementAt(this._selected));
            blobIterator = new BlobIterator(this._func.getList());
            blobIterator.init();
            int n = 0;
            while (!blobIterator.isDone() && n != this._selected) {
                blobIterator.incr();
                ++n;
            }
            if (n == this._selected) {
                blobIterator.curr()._point.add((Tuple3d)this._deltasum);
            }
        }
        object = new BlobIterator(this._new_blobs);
        ((BlobIterator)object).init();
        while (!((BlobIterator)object).isDone()) {
            System.out.println("Processing the new blob");
            this._func.getList().add(((BlobIterator)object).curr());
            blobIterator = new Transform3D(new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), new Vector3d((Tuple3d)((BlobIterator)object).curr()._point), this._def_rad * ((BlobIterator)object).curr()._rad);
            this._positions.addElement(blobIterator);
            TransformGroup transformGroup = new TransformGroup((Transform3D)blobIterator);
            transformGroup.setCapability(18);
            transformGroup.setCapability(17);
            transformGroup.addChild((Node)new Sphere(1.0f, 1, 10, this._ap));
            this._nodes.addElement(transformGroup);
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.addChild((Node)transformGroup);
            this._bgs.addElement(branchGroup);
            this._bg.addChild((Node)branchGroup);
            ((BlobIterator)object).incr();
        }
        this._new_blobs.clear();
        if (this._delete_selection) {
            object = new BlobIterator(this._func.getList());
            ((BlobIterator)object).init();
            int n = 0;
            while (!((BlobIterator)object).isDone() && n != this._selected) {
                ((BlobIterator)object).incr();
                ++n;
            }
            if (n == this._selected) {
                this._func.getList().remove(((BlobIterator)object).curr());
            }
            System.out.println("remove " + this._selected);
            this._positions.removeElementAt(this._selected);
            this._nodes.removeElementAt(this._selected);
            ((BranchGroup)this._bgs.elementAt(this._selected)).detach();
            this._bgs.removeElementAt(this._selected);
            this._delete_selection = false;
        }
        if (this._increase_influence) {
            System.out.println("Increasing influence of " + this._selected);
            object = new BlobIterator(this._func.getList());
            ((BlobIterator)object).init();
            int n = 0;
            while (!((BlobIterator)object).isDone() && n != this._selected) {
                ((BlobIterator)object).incr();
                ++n;
            }
            if (n == this._selected) {
                ((BlobIterator)object).curr()._rad += 0.1;
            }
            this._positions.setElementAt(new Transform3D(new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), new Vector3d((Tuple3d)((BlobIterator)object).curr()._point), this._def_rad * ((BlobIterator)object).curr()._rad), this._selected);
            ((TransformGroup)this._nodes.elementAt(this._selected)).setTransform((Transform3D)this._positions.elementAt(this._selected));
            this._increase_influence = false;
        }
        if (this._decrease_influence) {
            System.out.println("Decreasing influence of " + this._selected);
            object = new BlobIterator(this._func.getList());
            ((BlobIterator)object).init();
            int n = 0;
            while (!((BlobIterator)object).isDone() && n != this._selected) {
                ((BlobIterator)object).incr();
                ++n;
            }
            if (n == this._selected) {
                ((BlobIterator)object).curr()._rad -= 0.1;
            }
            this._positions.setElementAt(new Transform3D(new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), new Vector3d((Tuple3d)((BlobIterator)object).curr()._point), this._def_rad * ((BlobIterator)object).curr()._rad), this._selected);
            ((TransformGroup)this._nodes.elementAt(this._selected)).setTransform((Transform3D)this._positions.elementAt(this._selected));
            this._decrease_influence = false;
        }
        if (this._negate_influence) {
            System.out.println("Negating influence of " + this._selected);
            object = new BlobIterator(this._func.getList());
            ((BlobIterator)object).init();
            int n = 0;
            while (!((BlobIterator)object).isDone() && n != this._selected) {
                ((BlobIterator)object).incr();
                ++n;
            }
            if (n == this._selected) {
                ((BlobIterator)object).curr()._rad *= -1.0;
            }
            this._positions.setElementAt(new Transform3D(new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0), new Vector3d((Tuple3d)((BlobIterator)object).curr()._point), this._def_rad * ((BlobIterator)object).curr()._rad), this._selected);
            ((TransformGroup)this._nodes.elementAt(this._selected)).setTransform((Transform3D)this._positions.elementAt(this._selected));
            this._negate_influence = false;
        }
        this._func.computeSlopeBound();
        this._illus.updateDisplay();
        this._deltasum.set(0.0, 0.0, 0.0);
    }
}

